/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.benefit;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.UnknownNullability;
import team.creative.solonion.api.BenefitPlayerData;
import team.creative.solonion.common.benefit.BenefitStack;
import team.creative.solonion.common.benefit.BenefitType;

public class BenefitPlayerDataImpl
implements BenefitPlayerData {
    private HashMap<BenefitType, Object> applied = new HashMap();

    @Override
    public void updateStack(Player player, BenefitStack benefits) {
        for (BenefitType type : BenefitType.types()) {
            Object app = this.applied.get(type);
            Object stack = benefits.get(type);
            if (app == null) {
                if (stack == null) continue;
                app = type.createApplied();
                this.applied.put(type, app);
            }
            if (!type.apply(player, app, stack)) continue;
            this.applied.remove(type);
        }
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<BenefitType, Object> entry : this.applied.entrySet()) {
            Tag tag = entry.getKey().saveApplied(entry.getValue());
            if (tag == null) continue;
            nbt.put(entry.getKey().getId(), tag);
        }
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        for (Map.Entry<BenefitType, Object> entry : this.applied.entrySet()) {
            entry.getKey().clearApplied(entry.getValue());
        }
        if (nbt == null) {
            return;
        }
        for (BenefitType type : BenefitType.types()) {
            if (nbt.contains(type.getId())) {
                Object app = this.applied.get(type);
                if (app == null) {
                    app = type.createApplied();
                    this.applied.put(type, app);
                }
                type.loadApplied(app, nbt.get(type.getId()));
                continue;
            }
            this.applied.remove(type);
        }
    }

    @Override
    public <T> T getApplied(BenefitType<?, ?, T> type) {
        return (T)this.applied.get(type);
    }
}

